/******************************************************************************\
**
**     COMPANY:	LDW Software
**
**      MODULE:	TutorialTip
**
** DESCRIPTION:	Manages tutorial tips and instructions
**
**      AUTHOR:	Adrian Francis
**
\******************************************************************************/

#ifndef TUTORIAL_TIP_H
#define TUTORIAL_TIP_H

/******************************************************************************\
** LIBRARY INCLUDES
\******************************************************************************/
#include "ldwScene.h"
#include "../Dialogs/theTipDialog.h"
#include "../Game/Isola.h"	//EGameScene
#include "../Utils/theStringManager.h"

/******************************************************************************\
** CONSTANT DEFINITIONS
\******************************************************************************/
const int TutorialTip_c_iMaxTutorialTips = eTipTerminator - eTTipBeginNewTTips;
const int TutorialTip_c_iMaxInfoTip      = eTTipLastInfoTip - eTTipBeginNewTTips;
const int TutorialTip_c_iMaxQueueSize    = 10;

#define TIP_OPTION_NOFOCUS	(1 << 0)	// No villager focus

/******************************************************************************\
** CLASS DEFINITIONS
\******************************************************************************/
class CTutorialTip
{
private:

	//class structures
	struct STutorialTip
	{
		bool			m_bWasDisplayed;
		unsigned int	m_uiOptions;
		ArrowDirection	m_eArrowDirection;
		int				m_iArrowX;
		int				m_iArrowY;
		bool			m_bArrowOnWorld;
		int				m_iViewX;
		int				m_iViewY;
	};

	struct SQueuedTip
	{
		EGameScene	m_eScene;
		StringId	m_eString;
	};

public:

	struct SSaveState
	{
		STutorialTip	m_sTutorialTip[TutorialTip_c_iMaxTutorialTips];
		StringId		m_eLastTip;
	};

private:

	//class data
	STutorialTip	m_sTutorialTip[TutorialTip_c_iMaxTutorialTips];
	SQueuedTip		m_sQueue[TutorialTip_c_iMaxQueueSize];

	bool			m_bIsTipDisplayed;
	StringId		m_eLastTip;

	//class methods
	//setup
	public:		CTutorialTip();
	public:		void Reset();
	public:		const bool LoadState(const SSaveState &sSaveState);
	public:		const bool SaveState(SSaveState &sSaveState) const;
	public:		void ConfigureTip(const StringId eString, const unsigned int uiOptions, const ArrowDirection eArrowDirection, const int iArrowX, const int iArrowY, const bool bArrowOnWorld, const int iViewX, const int iViewY);

	//process
	public:		bool HandleSpecialCase(const StringId eString);
	public:		const StringId Update(const EGameScene eGameScene, ldwScene *pScene);
	public:		void Queue(const StringId eString, const EGameScene eGameScene = eGameScene_Main,bool alwaysQueue = false);
	public:		int  Display(const StringId eString, ldwScene *pScene);
	public:		void DisableTips(bool allTips = false);
	public:		void RepeatLastTip();
	public:		void QueueNextInstruction();

	//access
	public:		void SetDisplayed(const StringId eString);
	public:		const bool IsDisplayed() const;
	public:		const bool WasDisplayed(const StringId eString) const;
	public:		const bool IsInstruction(const StringId eString) const;
	public:		const bool IsNonInstructionQueuedFor(const EGameScene eGameScene) const;
	public:		const StringId LastTip() const;
};

/******************************************************************************\
** GLOBAL DECLARATIONS
\******************************************************************************/
extern CTutorialTip		TutorialTip;

#endif

/******************************************************************************\
** END OF FILE
\******************************************************************************/
